# Towers of the Wild: Reworked (Datapack) <!-- omit in toc -->
[![Discord](https://img.shields.io/badge/Chat%20on-Discord-informational?style=flat&logo=discord&logoColor=white&color=7289DA)](https://discord.gg/qYvPxzg7gM)

This pack is based on the popular Forge Mod [Towers of the Wild](https://www.curseforge.com/minecraft/mc-mods/towers-of-the-wild), 
so all credits go to the original Author [idrae_](https://www.curseforge.com/members/idrae_).

We really wanted to use this mod on 1.17+ so we decided to port it.

First, it started as as a Fabric Mod. **Starting with version v3.0.0, it's available as a Vanilla Datapack**, which means you don't even need any modloader!

### !!! Important !!!<!-- omit in toc -->
If you are running 1.18.1 or lower please refer to the branch for [1.17.x](https://github.com/WaldiNet/Towers_Of_The_Wild_Reworked/tree/1.17.x) or [1.18.1](https://github.com/WaldiNet/Towers_Of_The_Wild_Reworked/tree/fabric-1.18.1)

## Table of content <!-- omit in toc -->
* [Getting started](#getting-started)
  * [Features](#features)
* [How to install](#how-to-install)
* [Contributer](#contributer)


## Getting started
![Environment](https://img.shields.io/badge/environment-Client%20and%20Server-informational?style=flat)
![Modloader](https://img.shields.io/badge/Minecraft-Vanilla-informational?style=flat)
![Teamspeak](https://img.shields.io/badge/compatibile%20with-1.18.2%20|%201.19-informational?style=flat&logo=curseforge&logoColor=white&color=F26922)
[![Github SourceCode](https://img.shields.io/badge/SourceCode%20on-Github-informational?style=flat&logo=github&logoColor=white&color=3A414A)](https://github.com/xPand4B/Towers_Of_The_Wild_Reworked)

This datapack adds tall towers in your world, inspired by **The Legend Of Zelda: Breath Of The Wild**.

This will make your explorations a bit more exciting !

At the top of the tower *(which is purposely not so easy to climb)*, you will find a chest with some loot, as well as a nice view :)

Plus, it is also compatible with the [Waystones (Fabric Edition)](https://www.curseforge.com/minecraft/mc-mods/waystones-fabric) and [Fabric Waystones](https://www.curseforge.com/minecraft/mc-mods/fabric-waystones) mod. If you have one of these mods installed a waystone will spawn on top of each tower.

This pack does not add any blocks or items to the game *(if that matters to you)*.

![Tower Showcase 1](/img/showcase_1.png)
![Tower Showcase 2](/img/showcase_2.png)

<details>
  <summary><b>More images:</b></summary>

  ![Tower Showcase 3](/img/showcase_3.png)
  ![Tower Showcase 4](/img/showcase_4.png)
  ![Tower Showcase 5](/img/showcase_5.png)
  ![Tower Showcase 6](/img/showcase_6.png)
  ![Tower Showcase 7](/img/showcase_7.png)
</details>

### Features
* **Compatible with Vanilla, Fabric and Forge!**
  * If [Waystones (Fabric Edition)](https://www.curseforge.com/minecraft/mc-mods/waystones-fabric) or [Fabric Waystones](https://www.curseforge.com/minecraft/mc-mods/fabric-waystones) mod is active, waystones can spawn on top of each tower!
    * **Only install one of them!**
* Randomly generating Towers in your world
* Great loot on top of every Tower!
* Multiple Tower types
* Advancements for every tower *(Can you climb all of them?)*

## How to install
Simply put the file `Towers_Of_The_Wild-*.zip` inside the `.minecraft/saves/{WORLD}/datapacks` directory.

## Contributer
* [idrae_](https://github.com/Idrae) *(original author)*
* [RawPineapple](https://github.com/RawPineapple) *(translation for zh_cn)*
* [DracoExE](https://github.com/DracoExE) *(translation for es_cl)*
* [scarf005](https://github.com/scarf005) *(translation for ko_kr)*
* [WelpSTudenT](https://github.com/WelpSTudent)
